#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


//==============================================================================
//create reset vector at address 0xEFFE that will be used by bootloader
extern void near _Startup(void);
typedef void (*near tFunc)(void);
const tFunc rst_vec @0xEFFE = _Startup;

//==============================================================================
#define PERIOD 50000 //range 0 - 65535 
//toggle in interval 0.05s 
//period = PERIOD0 / timer clk
//period = 50000 / 1MHz = 0.05s

//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt void Unimplemented_ISR(void)
{
  asm BGND; //software breakpoint
}
#pragma CODE_SEG DEFAULT

//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt void TIM0_ISR(void)
{
  PTT_PTT4 = ~PTT_PTT4; //toggle LED on PORT T    
  
  TC0 = (unsigned int)(TC0 + PERIOD);    //toggle in interval 0.05s (PERIOD)
}
#pragma CODE_SEG DEFAULT
//==============================================================================


//==============================================================================
//This is an interurpt vector table located at 0x7F80 - 0x7FFF. 
//The interrupt vector base is set in main function to 0x7F.
//See the .prm file - the flash segment ROM_4000 must be cut of to area 0x4000-0x7F7F
//==============================================================================
typedef void (*near tIsrFunc)(void);
const tIsrFunc VectorTable[] @0x7F80 = 
{
  Unimplemented_ISR,    // Vector base + 0x80   Spurious interrupt                
  Unimplemented_ISR,    // Vector base + 0x82   Port AD interrupt
  Unimplemented_ISR,    // Vector base + 0x84   ADC compare interrupt        
  Unimplemented_ISR,    // Vector base + 0x86   Reserved                
  Unimplemented_ISR,    // Vector base + 0x88   Autonomous periodical interrupt (API)            
  Unimplemented_ISR,    // Vector base + 0x8A   Low-voltage interrupt (LVI)            
  Unimplemented_ISR,    // Vector base + 0x8C   Reserved           
  Unimplemented_ISR,    // Vector base + 0x8E   Port P interrupt            
  Unimplemented_ISR,    // Vector base + 0x90   Reserved        
  Unimplemented_ISR,    // Vector base + 0x92   Reserved        
  Unimplemented_ISR,    // Vector base + 0x94   Reserved        
  Unimplemented_ISR,    // Vector base + 0x96   Reserved        
  Unimplemented_ISR,    // Vector base + 0x98   Reserved        
  Unimplemented_ISR,    // Vector base + 0x9A   Reserved        
  Unimplemented_ISR,    // Vector base + 0x9C   Reserved        
  Unimplemented_ISR,    // Vector base + 0x9E   Reserved        
  Unimplemented_ISR,    // Vector base + 0xA0   Reserved        
  Unimplemented_ISR,    // Vector base + 0xA2   Reserved        
  Unimplemented_ISR,    // Vector base + 0xA4   Reserved        
  Unimplemented_ISR,    // Vector base + 0xA6   Reserved        
  Unimplemented_ISR,    // Vector base + 0xA8   Reserved        
  Unimplemented_ISR,    // Vector base + 0xAA   Reserved        
  Unimplemented_ISR,    // Vector base + 0xAC   Reserved        
  Unimplemented_ISR,    // Vector base + 0xAE   Reserved        
  Unimplemented_ISR,    // Vector base + 0xB0   CAN transmit   
  Unimplemented_ISR,    // Vector base + 0xB2   CAN receive   
  Unimplemented_ISR,    // Vector base + 0xB4   CAN errors   
  Unimplemented_ISR,    // Vector base + 0xB6   CAN wake-up   
  Unimplemented_ISR,    // Vector base + 0xB8   FLASH command   
  Unimplemented_ISR,    // Vector base + 0xBA   FLASH error   
  Unimplemented_ISR,    // Vector base + 0xBC   SPI2       
  Unimplemented_ISR,    // Vector base + 0xBE   SPI1
  Unimplemented_ISR,    // Vector base + 0xC0   Reserved        
  Unimplemented_ISR,    // Vector base + 0xC2   SCI2
  Unimplemented_ISR,    // Vector base + 0xC4   Reserved        
  Unimplemented_ISR,    // Vector base + 0xC6   PLL lock interrupt     
  Unimplemented_ISR,    // Vector base + 0xC8   Oscillator status interrupt     
  Unimplemented_ISR,    // Vector base + 0xCA   Reserved        
  Unimplemented_ISR,    // Vector base + 0xCC   ACMP        
  Unimplemented_ISR,    // Vector base + 0xCE   Port J
  Unimplemented_ISR,    // Vector base + 0xD0   Reserved        
  Unimplemented_ISR,    // Vector base + 0xD2   ADC 
  Unimplemented_ISR,    // Vector base + 0xD4   SCI1
  Unimplemented_ISR,    // Vector base + 0xD6   SCI0      
  Unimplemented_ISR,    // Vector base + 0xD8   SPI0      
  Unimplemented_ISR,    // Vector base + 0xDA   TIM Pulse accumulator input edge      
  Unimplemented_ISR,    // Vector base + 0xDC   TIM Pulse accumulator A overflow      
  Unimplemented_ISR,    // Vector base + 0xDE   TIM timer overflow      
  Unimplemented_ISR,    // Vector base + 0xE0   TIM timer channel 7      
  Unimplemented_ISR,    // Vector base + 0xE2   TIM timer channel 6      
  Unimplemented_ISR,    // Vector base + 0xE4   TIM timer channel 5      
  Unimplemented_ISR,    // Vector base + 0xE6   TIM timer channel 4      
  Unimplemented_ISR,    // Vector base + 0xE8   TIM timer channel 3      
  Unimplemented_ISR,    // Vector base + 0xEA   TIM timer channel 2      
  Unimplemented_ISR,    // Vector base + 0xEC   TIM timer channel 1      
  TIM0_ISR,             // Vector base + 0xEE   TIM timer channel 0      
  Unimplemented_ISR,    // Vector base + 0xF0   RTI timeout interrupt      
  Unimplemented_ISR,    // Vector base + 0xF2   IRQ      
  Unimplemented_ISR,    // Vector base + 0xF4   XIRQ      
  Unimplemented_ISR,    // Vector base + 0xF6   SWI      
  Unimplemented_ISR     // Vector base + 0xF8   Unimplemented instruction trap      
};                                                                         

//==============================================================================
//Timer_Init
//==============================================================================
void Timer_Init(void)
{
  TIOS = 0x01;   //channels 1 as output compare
  TCTL1 = 0x00;  //channels disconnected from pin logic    
  TIE = 0x01;    //interrupt enable for channel 0
  
  TC0 = (unsigned int)(TC0 + PERIOD);    //toggle in interval 0.05s (PERIOD)
  
  PTPSR = 0x07;  //precision prescaler set to 8 
  
  //bus clk = 8Mhz
  //timer clk = bus clk / prescaler = 8Mhz / 8 = 1MHz
  
  TSCR1 = 0xF8;  //enable timer, stop in wait mode, stop in freeze mode, 
                 //fast flag clear, precision prescaler enabled
}

//==============================================================================
// main
//==============================================================================
void main(void) {
  
  IVBR = 0x7F;  //set the vector base
  
  DDRT = 0x10;  //PTT4 as output
  
  Timer_Init(); //init TIM timer. Pin PTT0 will be toggled periodically (0.05s)
  
  EnableInterrupts;

  for(;;) {      
  } //wait forever  
  
}